---
name: Bug report
about: Create a report to help us improve

---

### Expected behavior

Add relevant code snippet, and what you expect it to do.

### Actual behavior

Add the script output, including any errors, warnings or notices.

### Steps to reproduce the behavior

Add the tesseract command generated by the library, example:

	<?php
	use thiagoalessio\TesseractOCR\TesseractOCR;
	echo (new TesseractOCR('text.png'))->lang('deu')->command;
	// "tesseract" "text.png" stdout -l deu

Also, if possible, attach the image(s) you are trying to recognize.

#### Environment

* Operating system: `$ uname -srvm` or `> winver`
* PHP version: `$ php --version`
* Tesseract version: `$ tesseract --version`
* tesseract-ocr-for-php version: `$ composer show thiagoalessio/tesseract_ocr`
